<?php

// app/Http/Controllers/Api/EmployeeController.php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Employee;
use Illuminate\Http\Request;

class EmployeeController extends Controller
{
    public function index()
    {
        return Employee::orderBy('name')->paginate(20);
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name'         => 'required|string|max:255',
            'phone'        => 'nullable|string|max:50',
            'cnic'         => 'nullable|string|max:50',
            'address'      => 'nullable|string',
            'role'         => 'required|in:sales,technician,cashier,manager',
            'salary_type'  => 'required|in:fixed,daily,hourly',
            'base_salary'  => 'nullable|numeric',
            'daily_rate'   => 'nullable|numeric',
            'hourly_rate'  => 'nullable|numeric',
            'commission_rate' => 'nullable|numeric',
            'start_date'   => 'nullable|date',
            'is_active'    => 'boolean',
        ]);

        $employee = Employee::create($data);

        return response()->json($employee, 201);
    }

    public function show(Employee $employee)
    {
        $employee->load(['attendances' => function ($q) {
            $q->latest()->limit(30);
        }]);

        return $employee;
    }

    public function update(Request $request, Employee $employee)
    {
        $data = $request->validate([
            'name'         => 'sometimes|string|max:255',
            'phone'        => 'sometimes|nullable|string|max:50',
            'cnic'         => 'sometimes|nullable|string|max:50',
            'address'      => 'sometimes|nullable|string',
            'role'         => 'sometimes|in:sales,technician,cashier,manager',
            'salary_type'  => 'sometimes|in:fixed,daily,hourly',
            'base_salary'  => 'sometimes|nullable|numeric',
            'daily_rate'   => 'sometimes|nullable|numeric',
            'hourly_rate'  => 'sometimes|nullable|numeric',
            'commission_rate' => 'sometimes|nullable|numeric',
            'start_date'   => 'sometimes|nullable|date',
            'end_date'     => 'sometimes|nullable|date',
            'is_active'    => 'sometimes|boolean',
        ]);

        $employee->update($data);

        return $employee;
    }

    public function destroy(Employee $employee)
    {
        $employee->delete();

        return response()->json(['message' => 'Deleted']);
    }
}
