<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AccessoryPurchase extends Model
{
    use HasFactory;

    protected $fillable = [
        'accessory_id',
        'supplier_id',
        'quantity',
        'unit_price',
        'total_amount',
        'gst_amount',
        'grand_total',
        'purchase_date',
        'invoice_number',
        'notes'
    ];

    protected $casts = [
        'quantity' => 'integer',
        'unit_price' => 'decimal:2',
        'total_amount' => 'decimal:2',
        'gst_amount' => 'decimal:2',
        'grand_total' => 'decimal:2',
        'purchase_date' => 'date'
    ];

    public function accessory()
    {
        return $this->belongsTo(Accessory::class);
    }

    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }

    public function stockMovement()
    {
        return $this->morphOne(AccessoryStockMovement::class, 'reference');
    }
}