<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AccessoryStockMovement extends Model
{
    use HasFactory;

    protected $fillable = [
        'accessory_id',
        'type',
        'quantity',
        'stock_before',
        'stock_after',
        'reference_id',
        'reference_type',
        'notes'
    ];

    protected $casts = [
        'quantity' => 'integer',
        'stock_before' => 'integer',
        'stock_after' => 'integer'
    ];

    public function accessory()
    {
        return $this->belongsTo(Accessory::class);
    }

    public function reference()
    {
        return $this->morphTo();
    }
}