<?php
// app/Models/EmployeeCommission.php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class EmployeeCommission extends Model
{
    protected $fillable = [
        'employee_id',
        'commission_date',
        'amount',
        'reference_type',
        'reference_id',
        'description',
    ];

    protected $casts = [
        'commission_date' => 'date',
    ];

    public function employee(): BelongsTo
    {
        return $this->belongsTo(Employee::class);
    }
}
