<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Expense extends Model
{
    use HasFactory;

    protected $fillable = [
        'expense_category_id',
        'expense_date',
        'amount',
        'payment_method',
        'reference_number',
        'description',
        'receipt_file',
        'paid_to_staff_id',
        'paid_to_supplier_id',
        'created_by'
    ];

    protected $casts = [
        'expense_date' => 'date',
        'amount' => 'decimal:2'
    ];

    // Relationship with category
    public function category()
    {
        return $this->belongsTo(ExpenseCategory::class, 'expense_category_id');
    }

  
    
    // Relationship with supplier
    public function supplier()
    {
        return $this->belongsTo(Supplier::class, 'paid_to_supplier_id');
    }

    // Relationship with user who created the record
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}