<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class InstallmentDocument extends Model
{
    protected $fillable = [
        'installment_id',
        'document_type',
        'file_name',
        'file_path',
        'mime_type',
        'file_size',
        'description',
    ];

    public function installment()
    {
        return $this->belongsTo(Installment::class);
    }

    // Helper to get full URL
    public function getUrlAttribute(): string
    {
        return asset('storage/' . $this->file_path);
    }
}
