<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $fillable = [
        'order_number',
        'order_type',
        'customer_id',
        'status',
        'payment_status',
        'order_date',
        'due_date',
        'sub_total',
        'discount_total',
        'tax_total',
        'grand_total',
        'amount_paid',
        'notes',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function items()
    {
        return $this->hasMany(OrderItem::class);
    }

    public function payments()
    {
        return $this->hasMany(OrderPayment::class);
    }

    public function installment()
    {
        return $this->hasOne(Installment::class);
    }

    // Check if order is installment type
    public function isInstallment(): bool
    {
        return $this->order_type === 'installment';
    }

    // Check if order is cash type
    public function isCash(): bool
    {
        return $this->order_type === 'cash';
    }
}