<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OrderItem extends Model
{
    protected $fillable = [
        'order_id',
        'item_type',
        'inventory_id',
        'inventory_item_id',
        'accessory_id',
        'description',
        'qty',
        'unit_price',
        'discount_amount',
        'tax_amount',
        'total',
    ];

    protected $casts = [
        'qty' => 'integer',
        'unit_price' => 'decimal:2',
        'discount_amount' => 'decimal:2',
        'tax_amount' => 'decimal:2',
        'total' => 'decimal:2',
    ];

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    public function inventory()
    {
        return $this->belongsTo(Inventory::class);
    }

    public function inventoryItem()
    {
        return $this->belongsTo(InventoryItem::class);
    }

    public function accessory()
    {
        return $this->belongsTo(Accessory::class);
    }

    // Check if item is device
    public function isDevice(): bool
    {
        return $this->item_type === 'device';
    }

    // Check if item is accessory
    public function isAccessory(): bool
    {
        return $this->item_type === 'accessory';
    }
}