<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payroll extends Model
{
    use HasFactory;

    protected $fillable = [
        'employee_id',
        'period_start',
        'period_end',
        'total_days',
        'total_hours',
        'base_pay',
        'commission_pay',
        'overtime_hours',
        'overtime_pay',
        'bonus',
        // 'deductions',
        // 'net_pay',

        // Allowances
'allowance_hra',
'allowance_fuel',
'allowance_phone',
'allowance_medical',
'allowance_meal',
'allowance_other',
'allowances_total',

// Gross
'gross_earnings',

// Deductions
'deduction_tax',
'deduction_advance',
'deduction_loan',
'deduction_penalty',
'deduction_other',
'deductions_total',

'net_pay',


        'status',
        'notes',
        'generated_by',
        'approved_by',
        'approved_at',
        'paid_by',
        'paid_at',
        'payment_method',
        'payment_reference',
    ];

    protected $casts = [
        'period_start' => 'date',
        'period_end' => 'date',
        'total_days' => 'integer',
        'total_hours' => 'decimal:2',
        'base_pay' => 'decimal:2',
        'commission_pay' => 'decimal:2',
        'overtime_hours' => 'decimal:2',
        'overtime_pay' => 'decimal:2',
        'bonus' => 'decimal:2',
        // 'deductions' => 'decimal:2',
        // 'net_pay' => 'decimal:2',
        // Allowances
'allowance_hra' => 'decimal:2',
'allowance_fuel' => 'decimal:2',
'allowance_phone' => 'decimal:2',
'allowance_medical' => 'decimal:2',
'allowance_meal' => 'decimal:2',
'allowance_other' => 'decimal:2',
'allowances_total' => 'decimal:2',

// Gross
'gross_earnings' => 'decimal:2',

// Deductions
'deduction_tax' => 'decimal:2',
'deduction_advance' => 'decimal:2',
'deduction_loan' => 'decimal:2',
'deduction_penalty' => 'decimal:2',
'deduction_other' => 'decimal:2',
'deductions_total' => 'decimal:2',

'net_pay' => 'decimal:2',

        'approved_at' => 'datetime',
        'paid_at' => 'datetime',
    ];

    /**
     * Get the employee that owns the payroll
     */
    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    /**
     * Get the user who generated the payroll
     */
    public function generatedBy()
    {
        return $this->belongsTo(User::class, 'generated_by');
    }

    /**
     * Get the user who approved the payroll
     */
    public function approvedBy()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }

    /**
     * Get the user who marked payroll as paid
     */
    public function paidBy()
    {
        return $this->belongsTo(User::class, 'paid_by');
    }

    /**
     * Scope for filtering by status
     */
    public function scopeStatus($query, $status)
    {
        return $query->where('status', $status);
    }

    /**
     * Scope for filtering by employee
     */
    public function scopeForEmployee($query, $employeeId)
    {
        return $query->where('employee_id', $employeeId);
    }

    /**
     * Scope for filtering by period
     */
    public function scopePeriod($query, $from, $to)
    {
        if ($from) {
            $query->whereDate('period_start', '>=', $from);
        }
        if ($to) {
            $query->whereDate('period_end', '<=', $to);
        }
        return $query;
    }
}