<?php


namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'purchase_id',
        'inventory_id',
        'quantity',
        'unit_price',
        'subtotal',
        'is_device', 
    ];

    protected function casts(): array
    {
        return [
            'quantity' => 'integer',
            'unit_price' => 'decimal:2',
            'subtotal' => 'decimal:2',
        ];
    }

    public function purchase()
    {
        return $this->belongsTo(Purchase::class);
    }

    public function inventory()
    {
        return $this->belongsTo(Inventory::class);
    }


    public function inventoryItem()
    {
        // return $this->hasMany(InventoryItem::class,'id','purchase_item_id');
        return $this->hasMany(InventoryItem::class,'purchase_item_id','id');
    }

 
    

    public function devices()   // 👈 new relation
    {
        return $this->hasMany(Device::class);
    }

}