<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReportSchedule extends Model
{
    use HasFactory;

    protected $table = 'report_schedules';

    protected $fillable = [
        'name',
        'type',
        'frequency',
        'format',
        'recipients',
        'next_run',
        'last_run',
        'is_active'
    ];

    protected $casts = [
        'next_run' => 'datetime',
        'last_run' => 'datetime',
        'is_active' => 'boolean'
    ];

    /**
     * Scope for active schedules
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Scope for schedules due to run
     */
    public function scopeDueToRun($query)
    {
        return $query->active()
            ->where('next_run', '<=', now());
    }
}