<?php

namespace App\Services;

use Maatwebsite\Excel\Facades\Excel;
use App\Exports\ReportExport;

class ExcelExportService
{
    /**
     * Export report data to Excel
     */
    public function export(string $reportType, array $data, string $fileName): string
    {
        $filePath = storage_path('app/temp/' . $fileName);
        
        // Ensure temp directory exists
        if (!file_exists(dirname($filePath))) {
            mkdir(dirname($filePath), 0755, true);
        }

        Excel::store(
            new ReportExport($reportType, $data),
            'temp/' . $fileName,
            'local'
        );

        return $filePath;
    }
}