<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable(); // link to users table if needed
            $table->string('name');
            $table->string('phone')->nullable();
            $table->string('cnic')->nullable();
            $table->string('address')->nullable();

            $table->enum('role', ['sales', 'technician', 'cashier', 'manager'])->default('sales');

            $table->enum('salary_type', ['fixed', 'daily', 'hourly'])->default('fixed');
            $table->decimal('base_salary', 12, 2)->nullable();      // for fixed monthly
            $table->decimal('daily_rate', 12, 2)->nullable();
            $table->decimal('hourly_rate', 12, 2)->nullable();

            $table->decimal('commission_rate', 5, 2)->nullable();    // percentage, if needed

            $table->decimal('allowance_hra', 10, 2)->default(0);
            $table->decimal('allowance_fuel', 10, 2)->default(0);
            $table->decimal('allowance_phone', 10, 2)->default(0);
            $table->decimal('allowance_medical', 10, 2)->default(0);

            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->boolean('is_active')->default(true);

            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->nullOnDelete();
        });


        Schema::create('employee_attendances', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->constrained()->cascadeOnDelete();

            $table->date('work_date');
            $table->dateTime('clock_in_at')->nullable();
            $table->dateTime('clock_out_at')->nullable();

            $table->integer('break_minutes')->default(0);
            $table->integer('total_minutes')->default(0);

            $table->enum('status', ['open', 'completed'])->default('open');

            $table->string('source')->default('mobile'); // mobile, web, admin
            $table->text('notes')->nullable();

            $table->timestamps();

            $table->unique(['employee_id', 'work_date']); // one record per day
        });



        // Schema::create('payrolls', function (Blueprint $table) {
        //     $table->id();
        //     $table->foreignId('employee_id')->constrained()->cascadeOnDelete();

        //     $table->date('period_start');
        //     $table->date('period_end');

        //     $table->integer('total_days')->default(0);
        //     $table->integer('total_hours')->default(0);

        //     $table->decimal('base_pay', 12, 2)->default(0);
        //     $table->decimal('overtime_pay', 12, 2)->default(0);
        //     $table->decimal('commission_pay', 12, 2)->default(0);
        //     $table->decimal('other_allowances', 12, 2)->default(0);
        //     $table->decimal('deductions', 12, 2)->default(0);
        //     $table->decimal('net_pay', 12, 2)->default(0);

        //     $table->enum('status', ['draft', 'approved', 'paid'])->default('draft');
        //     $table->text('notes')->nullable();

        //     $table->timestamps();
        // });



        Schema::create('payrolls', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->constrained()->onDelete('cascade');

            // Period
            $table->date('period_start');
            $table->date('period_end');

            // Attendance Summary
            $table->integer('total_days')->default(0);
            $table->decimal('total_hours', 8, 2)->default(0);

            // Payment Breakdown
            $table->decimal('base_pay', 10, 2)->default(0);
            $table->decimal('commission_pay', 10, 2)->default(0);
            $table->decimal('overtime_hours', 8, 2)->default(0);
            $table->decimal('overtime_pay', 10, 2)->default(0);
            $table->decimal('bonus', 10, 2)->default(0);
            // $table->decimal('deductions', 10, 2)->default(0);
            // $table->decimal('net_pay', 10, 2)->default(0);


            // Allowances breakdown
            $table->decimal('allowance_hra', 10, 2)->default(0);
            $table->decimal('allowance_fuel', 10, 2)->default(0);
            $table->decimal('allowance_phone', 10, 2)->default(0);
            $table->decimal('allowance_medical', 10, 2)->default(0);
            $table->decimal('allowance_meal', 10, 2)->default(0);
            $table->decimal('allowance_other', 10, 2)->default(0);
            $table->decimal('allowances_total', 10, 2)->default(0);

            // Gross earnings
            $table->decimal('gross_earnings', 10, 2)->default(0);

            // Deductions breakdown
            $table->decimal('deduction_tax', 10, 2)->default(0);
            $table->decimal('deduction_advance', 10, 2)->default(0);
            $table->decimal('deduction_loan', 10, 2)->default(0);
            $table->decimal('deduction_penalty', 10, 2)->default(0);
            $table->decimal('deduction_other', 10, 2)->default(0);
            $table->decimal('deductions_total', 10, 2)->default(0);

            $table->decimal('net_pay', 10, 2)->default(0);

            // Status Workflow
            $table->enum('status', ['draft', 'approved', 'paid'])->default('draft');

            // Notes
            $table->text('notes')->nullable();

            // Audit Trail
            $table->unsignedBigInteger('generated_by')->nullable();
            $table->unsignedBigInteger('approved_by')->nullable();
            $table->timestamp('approved_at')->nullable();
            $table->unsignedBigInteger('paid_by')->nullable();
            $table->timestamp('paid_at')->nullable();

            // Payment Details
            $table->string('payment_method')->nullable();
            $table->string('payment_reference')->nullable();

            $table->timestamps();

            // Indexes
            $table->index('employee_id');
            $table->index('status');
            $table->index(['period_start', 'period_end']);
            $table->unique(['employee_id', 'period_start', 'period_end']);
        });

        Schema::create('employee_commissions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->constrained()->cascadeOnDelete();

            $table->date('commission_date');
            $table->decimal('amount', 12, 2);
            $table->string('reference_type')->nullable(); // sale, repair, etc.
            $table->unsignedBigInteger('reference_id')->nullable(); // invoice_id, repair_id
            $table->string('description')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payroll_stuff');
    }
};
