<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('report_schedules', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('type'); // sales-summary, purchase-summary, etc.
            $table->enum('frequency', ['daily', 'weekly', 'monthly']);
            $table->enum('format', ['pdf', 'excel', 'csv']);
            $table->string('recipients'); // email addresses
            $table->timestamp('next_run')->nullable();
            $table->timestamp('last_run')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            $table->index('next_run');
            $table->index('is_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
         Schema::dropIfExists('report_schedules');
    }
};
