<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        // Add installment module settings
        DB::table('settings')->insert([
            [
                'key' => 'installment_module_enabled',
                'value' => '1',
                'group' => 'modules',
                'type' => 'boolean',
                'description' => 'Enable/Disable Installment Module',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'installment_default_markup_percentage',
                'value' => '10',
                'group' => 'installment',
                'type' => 'number',
                'description' => 'Default markup percentage for installments',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'installment_late_fee_percentage',
                'value' => '5',
                'group' => 'installment',
                'type' => 'number',
                'description' => 'Late fee percentage on overdue installments',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'installment_grace_period_days',
                'value' => '3',
                'group' => 'installment',
                'type' => 'number',
                'description' => 'Grace period in days before marking installment as overdue',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }

    public function down(): void
    {
        DB::table('settings')->whereIn('key', [
            'installment_module_enabled',
            'installment_default_markup_percentage',
            'installment_late_fee_percentage',
            'installment_grace_period_days',
        ])->delete();
    }
};