<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('expense_categories', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        Schema::create('expenses', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('expense_category_id');
            $table->date('expense_date');
            $table->decimal('amount', 10, 2);
            $table->string('payment_method')->nullable(); // cash, bank_transfer, card, etc.
            $table->string('reference_number')->nullable(); // invoice/receipt number
            $table->text('description')->nullable();
            $table->string('receipt_file')->nullable(); // file path for receipt/attachment
            $table->unsignedBigInteger('paid_to_staff_id')->nullable(); // if expense is staff salary/wage
            $table->unsignedBigInteger('paid_to_supplier_id')->nullable(); // if expense is supplier payment
            $table->unsignedBigInteger('created_by')->nullable(); // user who created the record
            $table->timestamps();

            // $table->foreign('expense_category_id')->references('id')->on('expense_categories')->onDelete('cascade');
            // $table->foreign('paid_to_staff_id')->references('id')->on('staff')->onDelete('set null');
            // $table->foreign('paid_to_supplier_id')->references('id')->on('suppliers')->onDelete('set null');
            // $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('expenses');
        Schema::dropIfExists('expense_categories');
    }
};