<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('order_items', function (Blueprint $table) {
            $table->foreignId('accessory_id')->nullable()->after('inventory_item_id')->constrained()->onDelete('cascade');
            $table->string('item_type')->default('device')->after('order_id'); // 'device' or 'accessory'
            
            // Make inventory fields nullable since accessories won't have them
            $table->foreignId('inventory_id')->nullable()->change();
            $table->foreignId('inventory_item_id')->nullable()->change();
        });
    }

    public function down()
    {
        Schema::table('order_items', function (Blueprint $table) {
            $table->dropForeign(['accessory_id']);
            $table->dropColumn(['accessory_id', 'item_type']);
        });
    }
};