<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Brand;
use App\Models\Category;
use App\Models\Supplier;
use App\Models\Customer;
use App\Models\Setting;
use App\Models\ExpenseCategory;
use Illuminate\Support\Facades\Hash;
use DB;

class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create Admin User
        User::create([
            'name' => 'Admin User',
            'username' => 'admin',
            'email' => 'admin@admin.com',
            'phone' => '+1234567890',
            'password' => Hash::make('password'),
            'role' => 'admin',
            'is_active' => true,
        ]);

        echo "✅ Admin user created successfully!\n";
        echo "   Email: admin@admin.com\n";
        echo "   Password: admin\n\n";

        // Create Sample Brands
        $brands = [
            ['name' => 'Xiaomi', 'slug' => 'xiaomi', 'country' => 'China'],
            ['name' => 'Samsung', 'slug' => 'samsung', 'country' => 'South Korea'],
            ['name' => 'Apple', 'slug' => 'apple', 'country' => 'USA'],
            ['name' => 'Tecno', 'slug' => 'tecno', 'country' => 'China'],
            ['name' => 'Infinix', 'slug' => 'infinix', 'country' => 'China'],
            ['name' => 'Oppo', 'slug' => 'oppo', 'country' => 'China'],
            ['name' => 'Vivo', 'slug' => 'vivo', 'country' => 'China'],
            ['name' => 'Huawei', 'slug' => 'huawei', 'country' => 'China'],
            ['name' => 'OnePlus', 'slug' => 'oneplus', 'country' => 'China'],
            ['name' => 'Realme', 'slug' => 'realme', 'country' => 'China'],
        ];

        foreach ($brands as $brand) {
            Brand::create($brand);
        }

        echo "✅ Sample brands created successfully!\n\n";

        // Create Sample Categories
        $categories = [
            ['name' => 'Smartphones', 'slug' => 'smartphones', 'description' => 'Mobile phones and smartphones'],
            ['name' => 'Tablets', 'slug' => 'tablets', 'description' => 'Tablets and iPads'],
            ['name' => 'Accessories', 'slug' => 'accessories', 'description' => 'Phone accessories like cases, chargers, etc'],
            ['name' => 'Smart Watches', 'slug' => 'smart-watches', 'description' => 'Smart watches and wearables'],
            ['name' => 'Feature Phones', 'slug' => 'feature-phones', 'description' => 'Basic feature phones'],
        ];

        foreach ($categories as $category) {
            Category::create($category);
        }

        echo "✅ Sample categories created successfully!\n\n";

        // Create Sample Suppliers
        $suppliers = [
            [
                'name' => 'Tech Wholesale Pakistan',
                'company_name' => 'Tech Wholesale (Pvt) Ltd',
                'email' => 'info@techwholesale.pk',
                'phone' => '+92-300-1234567',
                'address' => 'Plaza 123, Main Boulevard',
                'city' => 'Karachi',
                'country' => 'Pakistan',
            ],
            [
                'name' => 'Mobile Mart Suppliers',
                'company_name' => 'Mobile Mart International',
                'email' => 'sales@mobilemart.com',
                'phone' => '+92-321-9876543',
                'address' => 'Shop 45, Electronic Market',
                'city' => 'Lahore',
                'country' => 'Pakistan',
            ],
        ];

        foreach ($suppliers as $supplier) {
            Supplier::create($supplier);
        }

        echo "✅ Sample suppliers created successfully!\n\n";

        // Create Sample Customers
        // $customers = [
        //     [
        //         'name' => 'Ali Ahmed',
        //         'email' => 'ali@example.com',
        //         'phone' => '+92-300-1111111',
        //         'address' => 'House 123, Street 5, DHA',
        //         'city' => 'Karachi',
        //         'country' => 'Pakistan',
        //         'customer_type' => 'retail',
        //         'credit_limit' => 0,
        //     ],
        //     [
        //         'name' => 'Fatima Khan',
        //         'email' => 'fatima@example.com',
        //         'phone' => '+92-321-2222222',
        //         'address' => 'Apartment 45, Gulshan',
        //         'city' => 'Karachi',
        //         'country' => 'Pakistan',
        //         'customer_type' => 'retail',
        //         'credit_limit' => 50000,
        //     ],
        //     [
        //         'name' => 'Mobile World Shop',
        //         'email' => 'mobileworld@example.com',
        //         'phone' => '+92-333-3333333',
        //         'address' => 'Shop 78, Saddar',
        //         'city' => 'Karachi',
        //         'country' => 'Pakistan',
        //         'customer_type' => 'wholesale',
        //         'credit_limit' => 500000,
        //     ],
        // ];

        // foreach ($customers as $customer) {
        //     Customer::create($customer);
        // }

        echo "✅ Sample customers created successfully!\n\n";

        // 
        // 
        $faker = \Faker\Factory::create();
        // Generate 197 more (total = 200)
        for ($i = 1; $i <= 500; $i++) {

            // Randomly choose customer type
            $type = $faker->randomElement(['retail', 'wholesale']);

            // Credit limit logic
            $creditLimit =
                $type === 'retail'
                ? $faker->randomElement([0, 5000, 10000, 20000, 30000]) // retail typically small or no credit
                : $faker->randomElement([50000, 100000, 200000, 300000, 500000]); // wholesale shops

            $customers[] = [
                'name'  => $faker->name(),
                'email' => $faker->unique()->email(),
                'phone' => '+92-' . $faker->numberBetween(300, 349) . '-' . $faker->numerify('#######'),
                'address' => $faker->streetAddress(),
                'city' => $faker->randomElement(['Karachi', 'Lahore', 'Islamabad', 'Rawalpindi', 'Faisalabad', 'Hyderabad']),
                'country' => 'Pakistan',
                'customer_type' => $type,
                'credit_limit' => $creditLimit,
            ];
        }

        // Save customers
        foreach ($customers as $customer) {
            Customer::create($customer);
        }

        echo "✅ 200 customers created successfully!\n";



        // 
        // 

        // Ensure default settings exist
        $defaultSettings = [
            [
                'key' => 'invoice_prefix',
                'value' => 'INV',
                'type' => 'string',
                'group' => 'invoice',
                'description' => 'Prefix for invoice numbers',
            ],
            [
                'key' => 'purchase_prefix',
                'value' => 'PUR',
                'type' => 'string',
                'group' => 'purchase',
                'description' => 'Prefix for purchase numbers',
            ],
            [
                'key' => 'tax_rate',
                'value' => '0',
                'type' => 'number',
                'group' => 'general',
                'description' => 'Tax rate percentage',
            ],
            [
                'key' => 'currency',
                'value' => 'PKR',
                'type' => 'string',
                'group' => 'general',
                'description' => 'Default currency',
            ],
        ];

        foreach ($defaultSettings as $setting) {
            Setting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }


        DB::table('expense_categories')->truncate();

        $categories = [
            [
                'name' => 'Rent',
                'description' => 'Shop/office rent payments',
                'is_active' => true
            ],
            [
                'name' => 'Utilities',
                'description' => 'Electricity, water, internet, phone bills',
                'is_active' => true
            ],
            [
                'name' => 'Salaries & Wages',
                'description' => 'Staff salaries and wage payments',
                'is_active' => true
            ],
            [
                'name' => 'Supplies',
                'description' => 'Office and shop supplies',
                'is_active' => true
            ],
            [
                'name' => 'Repairs & Maintenance',
                'description' => 'Equipment and facility repairs',
                'is_active' => true
            ],
            [
                'name' => 'Marketing & Advertising',
                'description' => 'Promotional activities and advertising',
                'is_active' => true
            ],
            [
                'name' => 'Transportation',
                'description' => 'Fuel, vehicle maintenance, delivery costs',
                'is_active' => true
            ],
            [
                'name' => 'Insurance',
                'description' => 'Business and equipment insurance',
                'is_active' => true
            ],
            [
                'name' => 'Professional Fees',
                'description' => 'Accounting, legal, consulting fees',
                'is_active' => true
            ],
            [
                'name' => 'Bank Charges',
                'description' => 'Bank fees and transaction charges',
                'is_active' => true
            ],
            [
                'name' => 'Miscellaneous',
                'description' => 'Other business expenses',
                'is_active' => true
            ]
        ];

        foreach ($categories as $category) {
            ExpenseCategory::create($category);
        }






        echo "✅ Default settings configured successfully!\n\n";

        echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
        echo "🎉 SETUP COMPLETED SUCCESSFULLY!\n";
        echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
        echo "📊 Created:\n";
        echo "   • 1 Admin User\n";
        echo "   • 8 Brands\n";
        echo "   • 5 Categories\n";
        echo "   • 2 Suppliers\n";
        echo "   • 3 Customers\n";
        echo "   • 4 System Settings\n\n";
        echo "🔐 Login Credentials:\n";
        echo "   Email: admin@admin.com\n";
        echo "   Password: admin\n\n";
        echo "🚀 You can now start using the API!\n";
        echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    }
}
