<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>{{ $title }}</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
            color: #333;
            line-height: 1.6;
        }
        .header {
            background: #667eea;
            color: white;
            padding: 20px;
            margin-bottom: 30px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        .header .period {
            margin-top: 10px;
            font-size: 14px;
            opacity: 0.9;
        }
        .info-section {
            margin-bottom: 20px;
            padding: 15px;
            background: #f9fafb;
            border-left: 4px solid #667eea;
        }
        .info-section h3 {
            margin-top: 0;
            color: #667eea;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        th {
            background: #667eea;
            color: white;
            padding: 12px;
            text-align: left;
            font-weight: 600;
        }
        td {
            padding: 10px 12px;
            border-bottom: 1px solid #e5e7eb;
        }
        tr:nth-child(even) {
            background: #f9fafb;
        }
        .summary-grid {
            display: table;
            width: 100%;
            margin-bottom: 30px;
        }
        .summary-item {
            display: table-cell;
            width: 25%;
            padding: 15px;
            background: #f9fafb;
            border-right: 2px solid white;
        }
        .summary-item:last-child {
            border-right: none;
        }
        .summary-label {
            font-size: 11px;
            color: #6b7280;
            margin-bottom: 5px;
        }
        .summary-value {
            font-size: 18px;
            font-weight: 700;
            color: #667eea;
        }
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 10px;
            color: #6b7280;
            padding: 10px;
            border-top: 1px solid #e5e7eb;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .font-bold {
            font-weight: 700;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ $title }}</h1>
        @if(isset($data['period']))
        <div class="period">
            Period: {{ $data['period']['start'] }} to {{ $data['period']['end'] }}
        </div>
        @endif
    </div>

    @if($reportType === 'sales-summary')
        @include('reports.pdf.sales-summary', ['data' => $data])
    @elseif($reportType === 'sales-by-customer')
        @include('reports.pdf.sales-by-customer', ['data' => $data])
    @elseif($reportType === 'sales-by-product')
        @include('reports.pdf.sales-by-product', ['data' => $data])
    @elseif($reportType === 'purchase-summary')
        @include('reports.pdf.purchase-summary', ['data' => $data])
    @elseif($reportType === 'stock-summary')
        @include('reports.pdf.stock-summary', ['data' => $data])
    @elseif($reportType === 'profit-loss')
        @include('reports.pdf.profit-loss', ['data' => $data])
    @elseif($reportType === 'cash-flow')
        @include('reports.pdf.cash-flow', ['data' => $data])
    @elseif($reportType === 'outstanding-receivables')
        @include('reports.pdf.outstanding-receivables', ['data' => $data])
    @else
        <div class="info-section">
            <h3>Report Data</h3>
            <pre>{{ print_r($data, true) }}</pre>
        </div>
    @endif

    <div class="footer">
        Generated on {{ $generatedAt }} | Mobile Shop Management System
    </div>
</body>
</html>