@if(isset($data['summary']))
<div class="summary-grid">
    <div class="summary-item">
        <div class="summary-label">Total Sales</div>
        <div class="summary-value">{{ $data['summary']['total_sales'] ?? 0 }}</div>
    </div>
    <div class="summary-item">
        <div class="summary-label">Total Amount</div>
        <div class="summary-value">PKR {{ number_format($data['summary']['total_amount'] ?? 0) }}</div>
    </div>
    <div class="summary-item">
        <div class="summary-label">Total Paid</div>
        <div class="summary-value">PKR {{ number_format($data['summary']['total_paid'] ?? 0) }}</div>
    </div>
    <div class="summary-item">
        <div class="summary-label">Total Due</div>
        <div class="summary-value">PKR {{ number_format($data['summary']['total_due'] ?? 0) }}</div>
    </div>
</div>
@endif

<table>
    <thead>
        <tr>
            <th>Invoice #</th>
            <th>Date</th>
            <th>Customer</th>
            <th class="text-right">Total</th>
            <th class="text-right">Paid</th>
            <th class="text-right">Due</th>
            <th>Status</th>
        </tr>
    </thead>
    <tbody>
        @forelse($data['sales'] ?? [] as $sale)
        <tr>
            <td>{{ $sale['invoice_number'] ?? '-' }}</td>
            <td>{{ $sale['sale_date'] ?? '-' }}</td>
            <td>{{ $sale['customer']['name'] ?? 'Walk-in' }}</td>
            <td class="text-right">PKR {{ number_format($sale['total_amount'] ?? 0) }}</td>
            <td class="text-right">PKR {{ number_format($sale['paid_amount'] ?? 0) }}</td>
            <td class="text-right">PKR {{ number_format($sale['due_amount'] ?? 0) }}</td>
            <td>{{ $sale['status'] ?? '-' }}</td>
        </tr>
        @empty
        <tr>
            <td colspan="7" class="text-center">No sales found for this period</td>
        </tr>
        @endforelse
    </tbody>
</table>